

import java.util.Hashtable;

import org.apache.xmlbeans.XmlOptions;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

public class ValidacioSignaturaXMLenveloping {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Dades de prova
		// Signatura a verificar
		String signature = Utils.readXmlFile("enveloping.xml");

		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psis.catcert.net/psis/catcert/dss");

		// Composici del missatge
		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#","ds");
		XmlOptions options= new XmlOptions();	
		options.setSaveSuggestedPrefixes(prefixes);

		// Creaci del missatge DSS
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb la signatura XML enveloping
		SignatureObjectType signaturetype = SignatureObjectType.Factory.parse(signature,options);		
		request.setSignatureObject(signaturetype);

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optInputs = request.addNewOptionalInputs();
		optInputs.addNewReturnProcessingDetails();
		optInputs.addNewReturnSignedResponse();

		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));
	}
}
