
import java.util.Hashtable;

import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;
import x0CoreSchema.oasisNamesTcDss1.DocumentType;
import x0CoreSchema.oasisNamesTcDss1.InlineXMLType;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.InputDocumentsDocument.InputDocuments;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.SignaturePtrDocument.SignaturePtr;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

public class ValidacioSignaturaXMLenveloped {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Dades de prova		
		// Signatura a verificar
		String EnvelopedSignature = Utils.readXmlFile("enveloped.xml");

		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psis.catcert.net/psis/catcert/dss");

		// Composici del missatge
		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#","ds");
		XmlOptions options= new XmlOptions();	
		options.setSaveSuggestedPrefixes(prefixes);

		// Creaci del missatge DSS
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb la signatura XML enveloped
		InputDocuments inpDocuments = request.addNewInputDocuments();		
		DocumentType doc = inpDocuments.addNewDocument();
		doc.setID("EnvelopedSig");
		InlineXMLType xml = doc.addNewInlineXML();
		xml.set(XmlObject.Factory.parse(EnvelopedSignature));

		//Punter a la signatura
		SignatureObjectType signaturetype = request.addNewSignatureObject();
		SignaturePtr pointer = signaturetype.addNewSignaturePtr();
		pointer.setWhichDocument("EnvelopedSig");

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optInputs = request.addNewOptionalInputs();
		optInputs.addNewReturnProcessingDetails();
		optInputs.addNewReturnSignedResponse();

		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));
	}
}
