

import java.util.Hashtable;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;

import org.apache.xmlbeans.XmlOptions;
import org.w3.x2000.x09.xmldsig.DigestMethodType;

import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.DocumentHashDocument.DocumentHash;
import x0CoreSchema.oasisNamesTcDss1.InputDocumentsDocument.InputDocuments;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

public class ValidacioSignaturaXMLTimestamp_profileTimeStamp {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Dades de prova
		// Timestamp a verificar
		String timestamp = Utils.readXmlFile("OASIS_XMLTimestamp.xml");

		// Dades del digest
		byte[] digest = Utils.readBase64File("OASIS_Timestamp-hash.dat");

		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psis.catcert.net/psis/catcert/dss");

		// Composici del missatge
		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema", "dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#", "ds");
		XmlOptions options = new XmlOptions();
		options.setSaveSuggestedPrefixes(prefixes);

		// Creaci del missatge DSS
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:timestamping");

		// Creaci de l'element amb els segell de temps
		SignatureObjectType signaturetype = SignatureObjectType.Factory.parse(timestamp,options);		
		request.setSignatureObject(signaturetype);

		// Creaci de l'element amb un document
		InputDocuments documents = request.addNewInputDocuments();		
		DocumentHash document = documents.addNewDocumentHash();
		//document.setID("Doc1");
		document.setDigestValue(digest);
		DigestMethodType method = document.addNewDigestMethod();
		method.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optInputs = request.addNewOptionalInputs();
		optInputs.addNewReturnProcessingDetails();

		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));
	}
}