

import java.util.Hashtable;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;

import org.apache.xmlbeans.XmlOptions;

import x0CoreSchema.oasisNamesTcDss1.DocumentType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.Base64DataDocument.Base64Data;
import x0CoreSchema.oasisNamesTcDss1.InputDocumentsDocument.InputDocuments;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

public class ValidacioSignaturaPDF {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Dades de prova		
		// Signatura a verificar	
		byte[] signature = Utils.getBytesFromFile("proves\\data\\idcat.pdf");
		String docMimeType = "application/pdf";

		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psis.catcert.net/psis/catcert/dsspdf");

		// Composici del missatge
		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");	
		XmlOptions options= new XmlOptions();
		options.setSaveSuggestedPrefixes(prefixes);

		// Creaci del missatge DSS i selecci de profile
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:DSS_PDF");

		//Creaci de l'element amb els documents a enviar
		InputDocuments inpDocuments = request.addNewInputDocuments();
		Base64Data b64data = Base64Data.Factory.newInstance();
		b64data.setByteArrayValue(signature);
		b64data.setMimeType(docMimeType);
		DocumentType document = inpDocuments.addNewDocument();
		document.setBase64Data(b64data);

		//OptionalInputs
		OptionalInputs optInputs = request.addNewOptionalInputs();
		optInputs.addNewReturnSignerIdentity();
		optInputs.addNewReturnSignatureReason();

		// Visualitzaci de la petici
		
		System.out.println(requestDocument.xmlText(options));
		
		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));
	}
}
