

import java.util.Hashtable;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;

import org.apache.xmlbeans.XmlOptions;

import x0Assertion.oasisNamesTcSAML2.AttributeType;
import x0CoreSchema.oasisNamesTcDss1.DocumentType;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.Base64DataDocument.Base64Data;
import x0CoreSchema.oasisNamesTcDss1.Base64SignatureDocument.Base64Signature;
import x0CoreSchema.oasisNamesTcDss1.InputDocumentsDocument.InputDocuments;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;
import x0ProfilesXSS.oasisNamesTcDss1.ReturnX509CertificateInfoDocument.ReturnX509CertificateInfo;

public class ValidacioSignaturaCMSdetached_Document {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psis.catcert.net/psis/catcert/dss");

		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#","ds");
		XmlOptions options= new XmlOptions();	
		options.setSaveSuggestedPrefixes(prefixes);

		// Composici del missatge
		// Signatura i document que es verificar
		byte[] cms_detached_signature = Utils.readBase64File("cms-signature.p7b");
		byte[] doc = Utils.readBase64File("cms-doc.dat");		

		// Creaci del missatge DSS
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb el document signat
		InputDocuments inpDocuments = request.addNewInputDocuments();		
		DocumentType docType = inpDocuments.addNewDocument();
		Base64Data document = docType.addNewBase64Data();
		document.setByteArrayValue(doc);

		// Creaci de l'element amb la signatura a validar
		SignatureObjectType signature = request.addNewSignatureObject();		
		Base64Signature b64signature = signature.addNewBase64Signature();
		b64signature.setByteArrayValue(cms_detached_signature);

		// Tipus de signatura disponibles
		// Signatura CAdES: 					http://uri.etsi.org/01733/v1.6.3#
		// Signatura CMS: 						urn:ietf:rfc:3852
		// Signatura XMLDsig: 					urn:ietf:rfc:3275
		// Signatura XAdES: 					http://uri.etsi.org/01903/v1.2.2#
		b64signature.setType("urn:ietf:rfc:3852");
		signature.setBase64Signature(b64signature);		

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optional = request.addNewOptionalInputs();
		optional.addNewReturnProcessingDetails();
		optional.addNewReturnSignedResponse();

		// Consulta dels atributs
		ReturnX509CertificateInfo info = optional.addNewReturnX509CertificateInfo();
		AttributeType Nom = info.addNewAttributeDesignator();
		Nom.setName("urn:catcert:psis:certificateAttributes:VinculatedPersonName");
		AttributeType Cognoms = info.addNewAttributeDesignator();
		Cognoms.setName("urn:catcert:psis:certificateAttributes:VinculatedPersonSurname");
		AttributeType NIF = info.addNewAttributeDesignator();
		NIF.setName("urn:catcert:psis:certificateAttributes:VinculatedPersonNIForNIE");

		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));
	}

}
