

import java.util.Hashtable;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;

import org.apache.xmlbeans.XmlOptions;

import x0CoreSchema.oasisNamesTcDss1.DocumentType;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.Base64DataDocument.Base64Data;
import x0CoreSchema.oasisNamesTcDss1.Base64SignatureDocument.Base64Signature;
import x0CoreSchema.oasisNamesTcDss1.InputDocumentsDocument.InputDocuments;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

public class ValidacioSignaturaCMS {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Configuraci local
		Utils.setProxyConfiguration();
		
		// Dades de prova

		// Signatura a verificar
		byte[] signature = Utils.readBase64File("C:\\Projects\\PSIS\\src\\proves\\cms-signature.dat");

		// Document en B64 que s'ha signat
		byte[] doc = Utils.readBase64File("C:\\Projects\\PSIS\\src\\proves\\cms-doc.dat");

		// Tipus de signatura
		String type = "urn:ietf:rfc:3852";

		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psisbeta.catcert.net/psis/catcert-test/dss");

		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#","ds");

		XmlOptions options= new XmlOptions();	
		options.setSaveSuggestedPrefixes(prefixes);

		// Creaci del missatge DSS
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);

		VerifyRequest request = requestDocument.addNewVerifyRequest();

		// Creaci de l'element amb la signatura CMS a verificar
		SignatureObjectType signatureType = request.addNewSignatureObject();

		Base64Signature b64signature = Base64Signature.Factory.newInstance();
		b64signature.setByteArrayValue(signature);
		b64signature.setType(type);

		signatureType.setBase64Signature(b64signature);

		// Creaci de l'element amb els documents a enviar
		InputDocuments inpDocuments = request.addNewInputDocuments();
		
		Base64Data b64data = Base64Data.Factory.newInstance();
		b64data.setByteArrayValue(doc);

		DocumentType document = inpDocuments.addNewDocument();
		document.setBase64Data(b64data);

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optional = request.addNewOptionalInputs();
		optional.addNewReturnProcessingDetails();
	
		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));

	}

}
