

import java.io.File;
import java.io.FileInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Security;
import java.util.Hashtable;

import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2000.x09.xmldsig.X509DataDocument;
import org.w3.x2000.x09.xmldsig.X509DataType;

//import com.bs.psis.test.certificate.*;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;

import x0Assertion.oasisNamesTcSAML2.AttributeType;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType.Other;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;
import x0ProfilesXSS.oasisNamesTcDss1.ReturnX509CertificateInfoDocument.ReturnX509CertificateInfo;

public class ValidacioCertificatSSL {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Configuraci local
		Utils.setProxyConfiguration();
		
		// Dades de prova
		
		// Inicialitzaci del client
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("https://psisbeta.catcert.net/psis/catcert-test/dss-secure");

		// Certificat que es verificar
		
		
		byte[] certificate = Utils.getBytesFromFile("proves\\certificats\\catcert_abarbeta.dat");
	  
		//configuraci socket TSL
		
		
		
		//Client keystore init
		//
		System.setProperty("javax.net.ssl.keyStore","C:\\Projects\\PSIS\\src\\proves\\certificats\\psisauth.p12");
		//Here we define the type of keystore jks, pkcs12 or the one containing the user keys
		System.setProperty("javax.net.ssl.keyStoreType","pkcs12");
		//	The keystore password
		System.setProperty("javax.net.ssl.keyStorePassword", "sIikZSmz");
			    
		//Cert must be added to cacerts using keytool or specified here
		
		System.setProperty("javax.net.ssl.trustStore","C:\\Program Files\\Java\\jre1.5.0_14\\lib\\security\\cacerts_pre");				
		System.setProperty("javax.net.ssl.trustStoreType", "JKS");
		System.setProperty("javax.net.ssl.trustStorePassord", "changeit");
		
		//System.setProperty("javax.net.debug", "ssl");

		System.setProperty("java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
	
		
		// Composici del missatge

		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#","ds");

		XmlOptions options= new XmlOptions();	
		options.setSaveSuggestedPrefixes(prefixes);

		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);

		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb el certificat a verificar
		SignatureObjectType signature = request.addNewSignatureObject();

		X509DataDocument x509doc = X509DataDocument.Factory.newInstance();
		X509DataType x509data = x509doc.addNewX509Data();
		
		XmlBase64Binary b64certificate = x509data.addNewX509Certificate();
		b64certificate.setByteArrayValue(certificate);
		
		Other any = signature.addNewOther();
		any.set(x509doc);
		
		signature.setOther(any);	
		
		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optional = request.addNewOptionalInputs();
		optional.addNewReturnProcessingDetails();			
				
	
		// Visualitzaci de la petici
		
		// Execuci del servei
		
		
		VerifyResponseDocument responseDocument = port.verify(requestDocument);
		
		System.out.println(requestDocument.xmlText(options));
		System.out.println(responseDocument.xmlText(options));
		
	
		// visualitzaci de la resposta
	
		

	}

}
