

import java.io.File;
import java.util.Hashtable;

import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;

import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlOptions;
import org.codehaus.xfire.gen.Wsdl11Generator;
import org.w3.x2000.x09.xmldsig.X509DataDocument;
import org.w3.x2000.x09.xmldsig.X509DataType;

//import wsdl.core._0._1.dss.tc.names.oasis.SOAPport;
//import wsdl.core._0._1.dss.tc.names.oasis.digitalSignatureServiceClient;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.OptionalInputsDocument.OptionalInputs;
import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType.Other;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

public class ValidacioCertificat {

	@SuppressWarnings("unchecked")
	public static void main(String args[]) throws Exception {

		// Configuraci local
		Utils.setProxyConfiguration();
		
		// Dades de prova
		
		// Certificat que es verificar
		byte[] certificate = Utils.readBase64File("certificats/certificate.dat");

		// Inicialitzaci del client
		
		digitalSignatureServiceClient proxy = new digitalSignatureServiceClient();
		SOAPport port = proxy.getdssPortSoap("http://psisbeta.catcert.net/psis/catcert-test/dss");

		// Composici del missatge

		// Definici dels namespaces correctes
		Hashtable prefixes = new Hashtable();
		prefixes.put("urn:oasis:names:tc:dss:1.0:core:schema","dss");
		prefixes.put("http://www.w3.org/2000/09/xmldsig#","ds");

		XmlOptions options= new XmlOptions();	
		options.setSaveSuggestedPrefixes(prefixes);

		// Creaci del missatge DSS
		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);

		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb el certificat a verificar
		SignatureObjectType signature = request.addNewSignatureObject();

		X509DataDocument x509doc = X509DataDocument.Factory.newInstance();
		X509DataType x509data = x509doc.addNewX509Data();
		
		XmlBase64Binary b64certificate = x509data.addNewX509Certificate();
		b64certificate.setByteArrayValue(certificate);
		
		Other any = signature.addNewOther();
		any.set(x509doc);
		
		signature.setOther(any);

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optional = request.addNewOptionalInputs();
		optional.addNewReturnProcessingDetails();
		
		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		VerifyResponseDocument responseDocument = port.verify(requestDocument);
		

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));

	}

}
