

import java.util.HashMap;
import java.util.Map;

import net.catcert.DigitalSignatureServiceStub;

import org.apache.xmlbeans.XmlOptions;
import org.w3.www._2000._09.xmldsig.DigestMethodType;
import org.w3.www._2000._09.xmldsig.KeyInfoType;
import org.w3.www._2000._09.xmldsig.X509DataType;

import schema.core._0._1.dss.tc.names.oasis.SignRequestDocument;
import schema.core._0._1.dss.tc.names.oasis.SignResponseDocument;
import schema.core._0._1.dss.tc.names.oasis.DocumentHashDocument.DocumentHash;
import schema.core._0._1.dss.tc.names.oasis.InputDocumentsDocument.InputDocuments;
import schema.core._0._1.dss.tc.names.oasis.KeySelectorDocument.KeySelector;
import schema.core._0._1.dss.tc.names.oasis.OptionalInputsDocument.OptionalInputs;
import schema.core._0._1.dss.tc.names.oasis.SignRequestDocument.SignRequest;
import oasis.names.tc.dss._1_0.core.wsdl.SOAPport;
import oasis.names.tc.dss._1_0.core.wsdl.digitalSignatureServiceClient;



//import com.bs.psis.test.utils.Utils;

public class SignaturaCMS_inputHash {

	public static void main(String[] args) throws Exception {
		
		XmlOptions options = new XmlOptions();

		Map namespacePrefixes = new HashMap();
		namespacePrefixes.put("xss", "urn:oasis:names:tc:dss:1.0:profiles:XSS");
		namespacePrefixes.put("dss", "urn:oasis:names:tc:dss:1.0:core:schema");
		options.setSaveSuggestedPrefixes(namespacePrefixes);

		// Creaci del missatge DSS
		SignRequestDocument requestDocument = SignRequestDocument.Factory.newInstance(options);
		SignRequest request = requestDocument.addNewSignRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb el document a signar (en aquest cas, el hash del document en base64)
		InputDocuments inpDocuments = request.addNewInputDocuments();
		DocumentHash doc = inpDocuments.addNewDocumentHash();
		DigestMethodType dm = doc.addNewDigestMethod();
		dm.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
		// Document a signar: el hash
		byte[] hash = Utils.readBase64File("hash.dat");
		doc.setDigestValue(hash);
		doc.setID("docID");
		request.setInputDocuments(inpDocuments);

		OptionalInputs optional = request.addNewOptionalInputs();

		KeySelector selector = optional.addNewKeySelector();
		KeyInfoType key = selector.addNewKeyInfo();
		X509DataType x509data = key.addNewX509Data();
		// Certificat amb que es generar la signatura o timestamp
		byte[] certificate = Utils.readBase64File("sig_certificate.dat");
		x509data.setX509Certificate(certificate);

		// Tipus de signatura disponibles
		// Signatura CAdES: 					http://uri.etsi.org/01733/v1.6.3#
		// Signatura CMS: 						urn:ietf:rfc:3852
		// Signatura XMLDsig: 					urn:ietf:rfc:3275
		// Signatura XAdES: 					http://uri.etsi.org/01903/1.2.2#
		optional.setSignatureType("urn:ietf:rfc:3852");

		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText(options));

		// Execuci del servei
		DigitalSignatureServiceStub digitalSignatureServiceStub = new DigitalSignatureServiceStub("http://psisbeta.catcert.net/psis/catcert-test/dss");
		requestDocument = SignRequestDocument.Factory.parse(requestDocument.newInputStream());

		SignResponseDocument responseDocument = digitalSignatureServiceStub.sign(requestDocument);

		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText(options));		
	}
}
